<!DOCTYPE html>
<html>
<head>
    <title>Email Logs</title>
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1>Email Logs</h1>
        <table class="table">
            <thead>
                <tr>
                    <th>Recipient</th>
                    <th>Subject</th>
                    <th>Status</th>
                    <th>Error Message</th>
                    <th>Attachments</th>
                    <th>Sent At</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($logs as $log)
                    <tr>
                        <td>{{ $log->recipient_email }}</td>
                        <td>{{ $log->subject }}</td>
                        <td>{{ $log->status }}</td>
                        <td>{{ $log->error_message ?? '-' }}</td>
                        <td>{{ $log->attachments ?? '-' }}</td>
                        <td>{{ $log->created_at }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        {{ $logs->links() }}
        <a href="{{ route('emails.form') }}" class="btn btn-primary">Back to Form</a>
    </div>
</body>
</html>
