<!DOCTYPE html>
<html>
<head>
    <title>Send Email</title>
    <script src="{{ asset('node_modules/ckeditor4/ckeditor.js') }}"></script>
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>
<body>
    <div class="container">
        <h1>Send Email</h1>
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('emails.send') }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label>Recipients (Select Users)</label>
                <select name="recipients[]" class="form-control" multiple>
                    @foreach ($users as $id => $email)
                        <option value="{{ $email }}">{{ $email }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>External Recipients (Comma-separated emails)</label>
                <input type="text" name="external_recipients" class="form-control" placeholder="e.g., user1@example.com,user2@example.com">
            </div>
            <div class="form-group">
                <label>BCC (Comma-separated emails)</label>
                <input type="text" name="bcc" class="form-control" placeholder="e.g., bcc1@example.com,bcc2@example.com">
            </div>
            <div class="form-group">
                <label>Subject</label>
                <input type="text" name="subject" class="form-control" required>
            </div>
            <div class="form-group">
                <label>Email Body</label>
                <textarea name="body" id="editor" class="form-control" required></textarea>
            </div>
            <div class="form-group">
                <label>Attachments</label>
                <input type="file" name="attachments[]" class="form-control" multiple>
            </div>
            <button type="submit" class="btn btn-primary">Send Email</button>
        </form>
        <a href="{{ route('emails.logs') }}" class="btn btn-secondary mt-3">View Logs</a>
    </div>

    <script>
        CKEDITOR.replace('editor', {
            height: 300,
        });
    </script>
</body>
</html>
