<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CustomEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $subject;
    public $body;
    public $attachments;
    public $bcc;

    public function __construct($subject, $body, $attachments = [], $bcc = [])
    {
        $this->subject = $subject;
        $this->body = $body;
        $this->attachments = $attachments;
        $this->bcc = $bcc;
    }

    public function build()
    {
        $email = $this->subject($this->subject)
                       ->html($this->body);

        // Add BCC
        foreach ($this->bcc as $bccEmail) {
            $email->bcc($bccEmail);
        }

        // Add attachments
        foreach ($this->attachments as $attachment) {
            $email->attach($attachment['path'], [
                'as' => $attachment['name'],
                'mime' => $attachment['mime'],
            ]);
        }

        return $email;
    }
}
